PRO grismeff

; IDL program for calculating grims efficiency

close,/all

listfilename=STRARR(7)
eff=FLTARR(7)
wavelength=FLTARR(7)

k=0
	fileName = DIALOG_PICKFILE (/WRITE, FILTER = '~/GRISM/list*')
	IF (fileName NE '') THEN BEGIN

		OPENR, 1, filename
		WHILE NOT EOF(1) DO BEGIN
			strtmp=''
			READF, 1, strtmp
			listfilename[k]=strtmp
			print,listfilename[k]
			k=k+1
		ENDWHILE                                      
		CLOSE, 1
		ENDIF

print,'Wavelength Reference Signal Efficiency'

;
; Main FOR Loop
;

FOR j=0,k-1 DO BEGIN

;
; List open
;
		OPENR, 1, listfilename[j]
		datafilename='' & reffilename = '' & WL=0
		READF, 1, WL
		READF, 1, datafilename
		READF, 1, DZERO
		READF, 1, reffilename
		wavelength[j]=WL
		CLOSE, 1
;
; Reference
;

print, 'Reference'

X=FLTARR(256)
Y=FLTARR(256)

WINDOW,0,xsize=1024,ysize=512

		i=0

		OPENR, 1, reffilename

		aho='' & READf,1,aho & READf,1,aho & READf,1,aho & READf,1,aho

		WHILE NOT EOF(1) DO BEGIN
			READF, 1, xx, yy
			X[i]=xx & Y[i]=yy
			X[i]=X[i]*0.1
			i=i+1
		ENDWHILE                                      

		CLOSE, 1

		plot,X,Y

        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base1=FIX(XY[0]/0.1)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base2=FIX(XY[0]/0.1)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base3=FIX(XY[0]/0.1)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base4=FIX(XY[0]/0.1)

	back1=Y[base1:base2]
	back1x=x[base1:base2]
	
	back2=Y[base3:base4]
	back2x=X[base3:base4]

	signal=Y[base2:base3]
	signalx=X[base2:base3]

	plot,signalx,signal-(mean(back1)+mean(back2))/2
	wait,0.5
	reftotal=total(signal-(mean(back1)+mean(back2))/2)

;
; datafile
;

print,'Data'

X=FLTARR(256)
Y=FLTARR(256)

		i=0

		OPENR, 1, datafilename

		aho='' & READf,1,aho & READf,1,aho & READf,1,aho & READf,1,aho

		WHILE NOT EOF(1) DO BEGIN
			READF, 1, xx, yy
			X[i]=xx & Y[i]=yy
			X[i]=X[i]*0.1+DZERO
			i=i+1
		ENDWHILE                                      

		CLOSE, 1

		plot,X,Y


        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base1=FIX(((XY[0]-DZERO)/0.1) > 0)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base2=FIX(((XY[0]-DZERO)/0.1) > 1)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base3=FIX(((XY[0]-DZERO)/0.1) < 254)
        CURSOR,xpos,ypos,3,/device
        XY = CONVERT_COORD(xpos,ypos,/device,/TO_DATA)
        base4=FIX (((XY[0]-DZERO)/0.1) < 255)

	back1=Y[base1:base2]
	back1x=x[base1:base2]
	
	back2=Y[base3:base4]
	back2x=X[base3:base4]

	signal=Y[base2:base3]
	signalx=X[base2:base3]

	plot,signalx,signal-(mean(back1)+mean(back2))/2

	sigtotal=total(signal-(mean(back1)+mean(back2))/2)

;
; print result
;
	eff[j]=sigtotal/reftotal
	print,wavelength[j],reftotal,sigtotal,eff[j]
;
;
;
ENDFOR ; list loop
;
; final plot
;
;plot,wavelength,eff
result=DIALOG_PLOT2(XDATA=wavelength,YDATA=eff,/YNOZERO,EXECUTE=[$
'PLOT, XDATA,YDATA,/YNOZERO',$
'OPLOT,XDATA,YDATA,psym=1'],$
XTITLE='Wavelength [nm]',YTITLE='Efficiency',Title='GRISM EFFICIENCY CURVE',$
/PS_OPTION,/ASCII_DUMP_OPTION)

message,'Finish!'
FINISH:
END
