FUNCTION NORMARRAY, array
	RETURN,array/MAX(array)
END

PRO FOCASCAL

	xwidth=450
	offset=350
	delay=0
	fit_order=2
;	samplefac=4; for FOCAS
	samplefac=1; forr LRIS
	pixscale=0.1
	compwidth=15
	ncomplines=10

	lpos=FLTARR(2)
	wave=FLTARR(2)
	compwave=FLTARR(ncomplines)

	linelist2=['6929.47','6143.06']
	
	compwave[0]=5852.49
	compwave[1]=5944.83
	compwave[2]=6096.16
	compwave[3]=6143.06
	compwave[4]=6266.50
	compwave[5]=6506.53
	compwave[6]=6598.95
	compwave[7]=6678.28
	compwave[8]=6717.04
	compwave[9]=6929.47
;;;
;;; main program
;;;

	filename=DIALOG_PICKFILE(PATH='~/IDL/FOCAS',filter='*.FITS')
	IF(STRLEN(filename) EQ 0) THEN RETURN
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

;
; read ascii extension
;
	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(image2),/device

;	find,a,xstars,ystars
;	print,xstars,ystars
;	result = FINDFILES ('*.FITS', COUNT = count)
;	print,result,count

;
; ASCII extension structure test
;
;	print,asciiext.SLTCPIX1 ; slit X-pos
;	print,asciiext.SLTCPIX2 ; slit Y-pos
;	print,asciiext.SLT_LEN  ; slit length

;
; Multi-Slit extraction test
;
;	ERASE
;	for i=0,52 do begin
;	IF (asciiext.SLTCPIX1)[i]-xwidth+offset LT 0 THEN XMIN=0 ELSE XMIN=(asciiext.SLTCPIX1)[i]-xwidth+offset
;	IF (asciiext.SLTCPIX1)[i]+xwidth+offset GT naxis[0] THEN XMAX=naxis[0] ELSE XMAX=(asciiext.SLTCPIX1)[i]+xwidth+offset
;	IF (asciiext.SLTCPIX2)[i]-FIX((asciiext.SLT_LEN)[i]/2/pixscale) LT 0 THEN YMIN=0 ELSE YMIN=(asciiext.SLTCPIX2)[i]-FIX((asciiext.SLT_LEN)[i]/2/pixscale)
;	IF (asciiext.SLTCPIX2)[i]+FIX((asciiext.SLT_LEN)[i]/2/pixscale) GT naxis[1] THEN YMAX=naxis[1] ELSE YMAX=(asciiext.SLTCPIX2)[i]+FIX((asciiext.SLT_LEN)[i]/2/pixscale)
;	IF YMAX LT 0 THEN YMAX=10
;	print,XMIN,XMAX,YMIN,YMAX
;	TV,BYTSCL($
;	congrid($
;;	image[(asciiext.SLTCPIX1)[i]-100:(asciiext.SLTCPIX1)[i]+100,$
;;		(asciiext.SLTCPIX2)[i]-FIX((asciiext.SLT_LEN)[i]/2/pixscale):(asciiext.SLTCPIX2)[i]+FIX((asciiext.SLT_LEN)[i]/2/pixscale)]$
;	image[XMIN:XMAX,YMIN:YMAX]$
;		,200,50$
;	)$
;	)$
;	,i
;
;	endfor
;	GOTO,FINISH

	XorY = DIALOG_MENU (['X-cut', 'Y-cut'], TITLE = 'Cutting direction?')
	CURSOR,line,column,/device
	line=line*samplefac
	column=column*samplefac
	CASE XorY of
	'X-cut': BEGIN
		X=FLTARR(naxis[0]) & Y=FLTARR(naxis[0])
		FOR i=0,naxis[0]-1 DO BEGIN
			X[i]=i
			Y[i]=image(i,column)
		ENDFOR
		END
	'Y-cut': BEGIN
		X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
		FOR i=0,naxis[1]-1 do begin
			X[i]=i
			Y[i]=image(line,i)
		ENDFOR
		END
	ENDCASE

	ERASE
	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
		XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	PRINT,Xnew,X2new
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]
;	PRINT,'Click Center (bottom)'
;	CURSOR,tmp,y2,3,/device
;	XY = CONVERT_COORD(tmp,y2,/device,/TO_DATA)
;	y2=XY[1]
	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]
;	PRINT,'Click Cont. Level'
;	CURSOR,tmp,cont,3,/device
;	XY = CONVERT_COORD(tmp,cont,/device,/TO_DATA)
;	cont=XY[1]
	
;	est=[abs(y2-y1),cen,abs(x1-x2),cont]
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[0]=DIALOG_MENU(linelist2, TITLE = 'Select Wavelength')
	lpos[0]=EST[1]

	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 1 time)'
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]
;	y1=XY[1]
;	PRINT,'Click Center (bottom)'
;	CURSOR,tmp,y2,3,/device
;	XY = CONVERT_COORD(tmp,y2,/device,/TO_DATA)
;	y2=XY[1]
;	print,'Click FWHM (left)'
;	cursor,x1,tmp,3,/device
;	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
;	x1=XY[0]
;	print,'Click FWHM (right)'
;	cursor,x2,tmp,3,/device
;	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
;	x2=XY[0]
;	print,'Click Cont. Level'
;	cursor,tmp,cont,3,/device
;	XY = CONVERT_COORD(tmp,cont,/device,/TO_DATA)
;	cont=XY[1]
	
;	est=[abs(y2-y1),cen,abs(x1-x2),cont]
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[1] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
	lpos[1]=EST[1]

;	PLOT,lpos,wave,/ynonzero,psym=2

	fit2_result=POLY_FIT(lpos,wave,1)
;	PRINT,'Fit Reults', fit2_result


;;;
;;; reidentify
;;;

	colnum=dialog_slider([1,40],prompt='How many cuts do you want to measure ?')
	fit_result=FLTARR(colnum+1,fit_order)
	lpos2=FLTARR(colnum+1,ncomplines)
	xpos=FLTARR(colnum+1)
	wave2=FLTARR(colnum+1,ncomplines)
	waveres=FLTARR(colnum+1,ncomplines)
	skew=FLTARR(colnum+1,ncomplines)
	kurt=FLTARR(colnum+1,ncomplines)
	FWHM=FLTARR(colnum+1,ncomplines)

	XXX=FLTARR(ncomplines*colnum)
	YYY=FLTARR(ncomplines*colnum)
	ZZZ=FLTARR(ncomplines*colnum)


colID=0
colstep=FIX(naxis[1]/(colnum+1))

new_fit_result=fit2_result

FOR column=colstep,naxis[1]-1,colstep DO BEGIN
print,colid,column
xpos[colid]=column
FOR i=0,ncomplines-1 DO BEGIN
	FOR k=0,naxis[0]-1 do begin
		X[k]=k
		Y[k]=image(k,column)
	ENDFOR
	cen=compwave[i]
	lposnew=(cen-compwidth-new_fit_result[0])/new_fit_result[1]
	Xnew=FIX(lposnew)
;	PRINT,lposnew,Xnew
	lposnew=(cen+compwidth-new_fit_result[0])/new_fit_result[1]
	X2new=FIX(lposnew)
;	PRINT,lposnew,X2new

;	PRINT,Xnew,X2new
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=NORMARRAY(YY)
;	PLOT,XX,YY

	lposnew=(cen-new_fit_result[0])/new_fit_result[1]
;	est=[abs(y2-y1),lposnew,abs(x1-x2),cont]
	est=[1,lposnew,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef
	
	skew[colID,i]=skewness(YY)
	kurt[colID,i]=kurtosis(YY)
;	print,skew[colID,i],kurt[colID,i]
;	OPLOT,XX,result
;	WAIT,delay

	wave2[colID,i]=cen
	lpos2[colID,i]=coef[1]
	FWHM[colID,i]=coef[2]
ENDFOR ; end of i loop

;
; wavecalib at one column
;
	fit_result[colID,*]=POLY_FIT(lpos2[colID,*],wave2[colID,*],1,wavefit)
	new_fit_result=fit_result[colID,*]
;	PRINT,'Fit Reults'
;	PRINT, fit_result[colID,*]
;	PLOT, lpos2[colID,*], wave2[colID,*], /ynozero,psym=2
;	OPLOT,lpos2[colID,*], wave2[colID,*]
;	WAIT,delay

;
; wavecalib residual
;
	waveres[colID,*]=wave2[colID,*]-wavefit
;	PLOT,wavefit,waveres[colID,*]
;	WAIT,delay

;
; FWHM vs. wavelength
;
;	PLOT,wavefit,FWHM[colID,*],/YNOZERO
;	WAIT,delay

	colID=colID+1
ENDFOR ; column loop

;n=0
;FOR l=0,colnum-1 do begin
;	FOR m=0,ncomplines-1 do begin
;	XXX[n]=xpos[l]
;	YYY[n]=lpos2[l,m]
;	ZZZ[n]=wave2[l,m]
;	n=n+1
;	ENDFOR
;ENDFOR

;WINDOW,0,xsize=1024,ysize=1024,TITLE='Wavelength Mapping'
;surface,wave2,Xpos,lpos2
;surface,waveres,Xpos,lpos2

WINDOW,0,xsize=1024,ysize=512,TITLE=''

REPEAT BEGIN
flag = DIALOG_MENU (['FWHM-WAVE','FWHM-SLITPOS','SKEW-WAVE','SKEW-SLITPOS','KURT-WAVE','KURT-SLITPOS','WAVE-X','WAVE-SLITPOS','CDELT','CRVAL','END'], TITLE = 'Continue ?')

	CASE flag OF
	'FWHM-WAVE': BEGIN
		plotcol=dialog_slider([0,colnum-1],prompt='Which column do you want to plot?')
                result=DIALOG_PLOT2(XDATA=wave2[plotcol,*],YDATA=FWHM[plotcol,*],$
			/YNOZERO,EXECUTE=[$
            		'PLOT, XDATA,YDATA,/YNOZERO',$
                	'OPLOT,XDATA,YDATA,psym=2'],$
             	   	XTITLE='Wavelength',YTITLE='FWHM',Title='',$
             	   	/PS_OPTION,/ASCII_DUMP_OPTION)
;		PLOT, wave2[plotcol,*],FWHM[plotcol,*],/YNOZERO
;		OPLOT,wave2[plotcol,*],FWHM[plotcol,*],psym=2
	END
	'FWHM-SLITPOS': BEGIN
		plotline=dialog_slider([0,ncomplines-1],prompt='Which line do you want to plot?')
		PLOT, xpos,FWHM[*,plotline],/YNOZERO
		OPLOT,xpos,FWHM[*,plotline],psym=2
	END
	'SKEW-WAVE': BEGIN
		plotcol=dialog_slider([0,colnum-1],prompt='Which column do you want to plot?')
                result=DIALOG_PLOT2(XDATA=wave2[plotcol,*],YDATA=skew[plotcol,*],$
			/YNOZERO,EXECUTE=[$
            		'PLOT, XDATA,YDATA,/YNOZERO',$
                	'OPLOT,XDATA,YDATA,psym=2'],$
             	   	XTITLE='Wavelength',YTITLE='FWHM',Title='',$
             	   	/PS_OPTION,/ASCII_DUMP_OPTION)
;		PLOT, wave2[plotcol,*],skew[plotcol,*],/YNOZERO
;		OPLOT,wave2[plotcol,*],skew[plotcol,*],psym=2
	END
	'SKEW-SLITPOS': BEGIN
		plotline=dialog_slider([0,ncomplines-1],prompt='Which line do you want to plot?')
		PLOT, xpos,skew[*,plotline],/YNOZERO
		OPLOT,xpos,skew[*,plotline],psym=2
	END
	'KURT-WAVE': BEGIN
		plotcol=dialog_slider([0,colnum-1],prompt='Which column do you want to plot?')
                result=DIALOG_PLOT2(XDATA=wave2[plotcol,*],YDATA=kurt[plotcol,*],$
			/YNOZERO,EXECUTE=[$
            		'PLOT, XDATA,YDATA,/YNOZERO',$
                	'OPLOT,XDATA,YDATA,psym=2'],$
             	   	XTITLE='Wavelength',YTITLE='FWHM',Title='',$
             	   	/PS_OPTION,/ASCII_DUMP_OPTION)
;		PLOT, wave2[plotcol,*],kurt[plotcol,*],/YNOZERO
;		OPLOT,wave2[plotcol,*],kurt[plotcol,*],psym=2
	END
	'KURT-SLITPOS': BEGIN
		plotline=dialog_slider([0,ncomplines-1],prompt='Which line do you want to plot?')
		PLOT, xpos,kurt[*,plotline],/YNOZERO
		OPLOT,xpos,kurt[*,plotline],psym=2
	END
	'WAVE-X': BEGIN
		plotcol=dialog_slider([0,colnum-1],prompt='Which column do you want to plot?')
                result=DIALOG_PLOT2(XDATA=lpos2[plotcol,*],YDATA=wave2[plotcol,*],$
			/YNOZERO,EXECUTE=[$
            		'PLOT, XDATA,YDATA,/YNOZERO',$
                	'OPLOT,XDATA,YDATA,psym=2'],$
             	   	XTITLE='Wavelength',YTITLE='FWHM',Title='',$
             	   	/PS_OPTION,/ASCII_DUMP_OPTION)
;		PLOT, lpos2[plotcol,*], wave2[plotcol,*], /YNOZERO
;		OPLOT,lpos2[plotcol,*], wave2[plotcol,*], psym=2
	END
	'WAVE-SLITPOS': BEGIN
		plotline=dialog_slider([0,ncomplines-1],prompt='Which line do you want to plot?')
		PLOT, xpos,lpos2[*,plotline],/YNOZERO
		OPLOT,xpos,lpos2[*,plotline],psym=2
	END
	'CDELT': BEGIN
		PLOT, xpos,fit_result[*,1],/YNOZERO
		OPLOT,xpos,fit_result[*,1],psym=2
	END
	'CRVAL': BEGIN
		PLOT,xpos,fit_result[*,0],/YNOZERO
		OPLOT,xpos,fit_result[*,0],psym=2
	END

	'END': BEGIN & END ; do nothing
	''   : BEGIN & END ; do nothing

	ENDCASE

ENDREP UNTIL flag EQ 'END'

FINISH:
END
