PRO FE

	samplefac=6; 2 for DAO

;;;
;;; main program
;;;

	filename=DIALOG_PICKFILE(PATH='/scr0/ohyama/CCD/',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
;	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read bias image array
;
;	bfilename=DIALOG_PICKFILE(PATH='/scr0/ohyama/CCD/',filter='*.fits')
;	IF(STRLEN(bfilename) EQ 0) THEN stop
;
; read main image array
;
;	bimage= MRDFITS(bfilename, 0, header)
;
; bias subtract
;
;	image = image - bimage
;	image = image < 1000 > (-500)
	image = image - median(image[2000:2040,50:300])
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE

;	TV,BYTSCL(sigrange(image2[0:naxis[0]-1,0:naxis[1]-1],fraction=0.99)),/device
	TV,BYTSCL(sigrange(image2[0:naxis[0]/samplefac-10,10:naxis[1]/samplefac-10],fraction=0.99)),/device

        CURSOR,line,column,/device
        line=line*samplefac & column=column*samplefac
       	startx=FIX(line)
	starty=FIX(column)
	print,startx,starty
	wait,1
        
	CURSOR,line,column,/device
        line=line*samplefac & column=column*samplefac
        endx=FIX(line)
	endy=FIX(column)
	print,endx,endy

;	peak=STDDEV(image[startx:endx,starty:endy])*5
	peak=100.
	print,'Noise level:',peak

;wait,1
;        CURSOR,line,column,/device
;        line=line*samplefac & column=column*samplefac
;        startx=FIX(line)
;	starty=FIX(column)
;	print,startx,starty
;wait,1
;        CURSOR,line,column,/device
;        line=line*samplefac & column=column*samplefac
;        endx=FIX(line)
;	endy=FIX(column)
;	print,endx,endy

	feimage=image[startx:endx,starty:endy]
;	tvscl,sigrange(feimage,fraction=0.999)
	imdisp,sigrange(feimage,fraction=0.999)

;	TV,BYTSCL(sigrange(image2,fraction=0.999)),/device
;	TV,BYTSCL(sigrange(image2[20:naxis[0]/samplefac-10,10:naxis[1]/samplefac-10],fraction=0.99)),/device

;wait,1
;        CURSOR,line,column,/device
;        line=line*samplefac & column=column*samplefac
;        startx2=FIX(line)
;	starty2=FIX(column)
;	print,startx2,starty2

;wait,1
;       CURSOR,line,column,/device
;        line=line*samplefac & column=column*samplefac
;        endx2=FIX(line)
;	endy2=FIX(column)
;	print,endx2,endy2

;	feimage2=image[startx2:endx2,starty2:endy2]
;	tvscl,sigrange(feimage2,fraction=0.999)

	print,'Calculation Start!'

;	countdb = REPLICATE({pixel, count:0.0, x:0.0, y:0.0, flag:0.0}, $
;		size(feimage,/N_ELEMENTS)+size(feimage2,/N_ELEMENTS))

	countdb = REPLICATE({pixel, count:0.0, x:0.0, y:0.0, flag:0.0}, $
		size(feimage,/N_ELEMENTS))

	feimage_minpeak=feimage > peak

	i=long(0)
	for x=0,abs(startx-endx)-1 do begin
		for y=0,abs(starty-endy)-1 do begin
			i=i+1
			countdb[i].count=feimage[x,y]
			x = x > 1 < (endx-startx-1)
			countdb[i].x=x+startx
			y= y > 1 < (endy-starty-1)
			countdb[i].y=y+starty
;
; filtering
;
			; If count < noise then reject (do nothing)
			if feimage[x,y  ] LT peak then begin
				countdb[i].count=0
				goto, donothing
			endif

			; If count in adjusting pixels < noise then accept as a single event
		
			tmp = feimage_minpeak[x+1,y  ] * feimage_minpeak[x  ,y+1] * feimage_minpeak[x-1,y  ] $
				* feimage_minpeak[x  ,y-1] * feimage_minpeak[x+1,y+1] * feimage_minpeak[x-1,y+1] $
				* feimage_minpeak[x-1,y-1] * feimage_minpeak[x+1,y-1]

			if tmp gt peak^8 then countdb[i].count = 0 else begin
			backgr = (feimage[x+1,y  ] + feimage[x  ,y+1] + feimage[x-1,y  ] $
				+ feimage[x  ,y-1] + feimage[x+1,y+1] + feimage[x-1,y+1] $
				+ feimage[x-1,y-1] + feimage[x+1,y-1])/8.
			countdb[i].count=countdb[i].count-backgr				
			print, i
			endelse
donothing:

		endfor
	endfor

; loop 2

;	for x=0,abs(startx2-endx2)-1 do begin
;		for y=0,abs(starty2-endy2)-1 do begin
;			i=i+1
;			countdb[i].count=feimage2[x,y]
;			x = x > 1 < (endx2-startx2-1)
;			countdb[i].x=x+startx2
;			y = y > 1 < (endy2-starty2-1)
;			countdb[i].y=y+starty2
;
; filtering
;
;			; If count < noise then reject (do nothing)
;			if feimage2[x,y  ] LT peak then goto, donothing2
;
;			; If count in adjusting pixels < noise then accept as a single event
;			if $
;			(feimage2[x+1,y  ] LT peak) AND $
;			(feimage2[x  ,y+1] LT peak) AND $
;			(feimage2[x-1,y  ] LT peak) AND $
;			(feimage2[x  ,y-1] LT peak) AND $
;			(feimage2[x+1,y+1] LT peak) AND $
;		 	(feimage2[x-1,y+1] LT peak) AND $
;	  		(feimage2[x-1,y-1] LT peak) AND $
;		  	(feimage2[x+1,y-1] LT peak) then begin
;			print,i
;			backgr = (feimage2[x+1,y  ] + feimage2[x  ,y+1] + feimage2[x-1,y  ] $
;				+ feimage2[x  ,y-1] + feimage2[x+1,y+1] + feimage2[x-1,y+1] $
;				+ feimage2[x-1,y-1] + feimage2[x+1,y-1])/8.
;			countdb[i].count = countdb[i].count - backgr
;			endif else begin
;				countdb[i].count=0
;			endelse
;donothing2:
;
;		endfor
;	endfor

;	countdb=countdb(sort(countdb.count))

	WINDOW,0,xsize=1000,ysize=500
	hist=histogram(countdb.count,max=max(feimage),min=peak)
	bin= FINDGEN(size(hist,/N_ELEMENTS))+peak
	plot,bin,hist,XRANGE=[peak,max(feimage)],YRANGE = [MIN(hist)-1, MAX(hist)+1], PSYM = 10

	print,'Select Fitting Region (Click two times)'
        CURSOR,cen,y1,3,/device
        XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
        fitstart=XY[0]
	wait,1
        CURSOR,cen,y1,3,/device
        XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
        fitend=XY[0]

	newbin=bin[FIX(fitstart-peak):FIX(fitend-peak)]
	newhist=hist[FIX(fitstart-peak):FIX(fitend-peak)]

	plot,newbin,newhist,XRANGE=[fitstart,fitend],YRANGE = [MIN(newhist)-1, MAX(newhist)+1], PSYM = 10

	PRINT,'Click TOP'	
	CURSOR,cen,y1,3,/device
        XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
        cen=XY[0] & y1=XY[1]
        PRINT,'Click FWHM (left)'
        CURSOR,x1,tmp,3,/device
        XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
        x1=XY[0]
        PRINT,'Click FWHM (right)'
        CURSOR,x2,tmp,3,/device
        XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
        x2=XY[0]
        
        est=[y1,cen,abs(x1-x2),0,0,0]
        result=GAUSSFIT(newbin,newhist,coef,NTERMS=6,ESTIMATE=est)
        PRINT,'peak at ',coef[1],' sigma:',coef[2]
	oplot,newbin,result

	result=DIALOG_PLOT2(XDATA=newbin,YDATA=newhist,/YNOZERO,psym=10,$
		XTITLE='Pixel Count',YTITLE='# of Pixels',Title=filename,$
		/PS_OPTION,/ASCII_DUMP_OPTION)

	WINDOW,1,xsize=1000,ysize=500
;	plot,countdb.y,countdb.count,psym=3,yrange=[coef[1]-coef[2]*3,coef[1]+coef[2]*3]
	result=DIALOG_PLOT2(XDATA=countdb.y,YDATA=countdb.count,/YNOZERO,psym=3,XTITLE='# of Charge Transform',YTITLE='Pixel Count',Title=filename,/PS_OPTION,/ASCII_DUMP_OPTION,yrange=[700,800])

message,'Finish!'
FINISH:
END
