PRO write_sbr_ccd_trans,X1,Y1,X2,Y2,xFOVCenter,yFOVCenter,width_pix,diameter_pix,type,delid,FilenameInput=filenameinput

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

if keyword_set(filenameinput) EQ 0 then begin
	filename=DIALOG_PICKFILE(filter='*.sbr')
	IF(STRLEN(filename) EQ 0) THEN return
end else begin
	filename=filenameinput
endelse

if size(delid,/n_dimension) NE 0 then begin
	x1[delid]=0; & x2[delid]=0 & y1[delid]=0 & y2[delid]=0
endif
;
; [X,Y]_distcenter must be your interest FOV center pos for previously distcalibed data
;
;read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

;params=dialog_input(prompt=["X FOV Center","Y FOV Center"],nfields=2,initial=[XDistCenter,YDistCenter],title='Input FOV Center')
params=dialog_input(prompt=["X FOV Center","Y FOV Center"],nfields=2,initial=[xFOVCenter,yFOVCenter],title='Input FOV Center')
if n_elements(params) NE 2 then goto,do_nothing
xFOVcenter=float(params[0])
yFOVcenter=float(params[1])

XCenter = xFOVcenter
YCenter = yFOVcenter

x1_offset = x1 - XCenter
x2_offset = x2 - XCenter
y1_offset = y1 - YCenter
y2_offset = y2 - YCenter

r1 = sqrt(x1_offset^2+y1_offset^2)*0.015/beta
r2 = sqrt(x2_offset^2+y2_offset^2)*0.015/beta

r1_trans = r1*(coef_inv[0] + coef_inv[1]*r1 + coef_inv[2]*r1^2 + coef_inv[3]*r1^3)
r2_trans = r2*(coef_inv[0] + coef_inv[1]*r2 + coef_inv[2]*r2^2 + coef_inv[3]*r2^3)

theta1 = atan(y1_offset,x1_offset)
theta2 = atan(y2_offset,x2_offset)

;mos_rot_offset=mos_rot;-0.7
;offset=mos_rot_offset*3.141592/180; MOS theta offset in radian
x1_focus=r1_trans*cos(theta1)*beta/0.015 + XMaskCenter
x2_focus=r2_trans*cos(theta2)*beta/0.015 + XMaskCenter
y1_focus=r1_trans*sin(theta1)*beta/0.015 + YMaskCenter
y2_focus=r2_trans*sin(theta2)*beta/0.015 + YMaskCenter

width=width_pix; width is in array
radius=diameter_pix/2

GET_LUN,U
on_ioerror, fopen_err
openw,U,filename

for i=0,n_elements(x1)-1 do begin; i=0 is assigned for del slit
	if x1[i] EQ 0 then goto,skip_loop
	print,type[i]
	if type[i] EQ 0 then begin
;		printF, U, x1[i],(y1+y2)[i]/2,x2[i],(y1+y2)[i]/2,width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
		printF, U, x1_focus[i],(y2_focus+y1_focus)[i]/2,x2_focus[i],(y1_focus+y2_focus)[i]/2,width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
	endif	else begin
;		printF, U, (x1[i]+x2[i])/2,(y1[i]+y2[i])/2,(x2-x1)[i]/2,format='("C,",F9.4,",",F9.4,",",F9.4)'
		printF, U, (x1_focus[i]+x2_focus[i])/2,(y1_focus[i]+y2_focus[i])/2,(x2_focus[i]-x1_focus[i])/2,format='("C,",F9.4,",",F9.4,",",F9.4)'
	endelse
skip_loop:
ENDFOR

close,U
FREE_LUN,U

goto, done
                                                                                
fopen_err:
result=dialog_message(!error_state.msg,/Error)
                                                                                
done:

do_nothing:
;message,'FINISH'
END
