pro calc_optimum_slit_mos,flatpattern,comppattern,slitpattern
;
; X shift
;
num=n_elements(flatpattern)
flatpattern_min=flatpattern[5:num-5]
comppattern_min=comppattern[5:num-5]

;window,21,title='Automatic Slitpattern Adjustment'
;!P.MULTI=[0,2,1]
res=fltarr(11)
for j=-5,5 do res[j+5]=robust_sigma(shift(flatpattern_min,j) / comppattern_min)
shiftvalue=findgen(11)-5
;plot,shiftvalue,res,/ynozero,xtitle='relative X shift',ytitle='RMS'
optimum_shift=shiftvalue[where(res EQ min(res))]
flatpatternshift=shift(flatpattern,optimum_shift[0])
;
; Factor
;
resfac=fltarr(61)
flatpatternshift_min=flatpattern[5:num-5]
for j=0,60 do resfac[j+0]=robust_sigma((flatpatternshift_min *j/10.+(1.-j/10.)) / comppattern_min)
factor=findgen(61)/10.
;plot,factor,resfac,/ynozero,xtitle='Relative scale factor',ytitle='RMS'
id=factor[where(resfac EQ min(resfac))]
slitpattern=flatpattern
;slitpattern=flatpatternshift*id[0]+(1.-id[0])
;
; Slit pattern check
;
;logger->append, ['	Do you find minima in both plots?','	If so, automatic slit adjustment is working well.']
print,'Do you find minima in both plots?','	If so, automatic slit adjustment is working well.'

;temp=sigrange(slitpattern # slitpattern,range=range)
;window,2,xsize=1000,ysize=500,title='2D slit pattern (UL: slit (shifted), UR: comp, LL: ratio'
;!P.MULTI=[0,2,2]
;tv,bytscl(flatpattern # flatpattern,min=range[0],max=range[1])
;tv,bytscl(comppattern # comppattern,min=range[0],max=range[1])
;tv,bytscl(slitpattern # slitpattern / (comppattern # comppattern),min=range[0],max=range[1])
;!P.MULTI=0

print,'Flat RMS',robust_sigma(flatpattern_min),'Comp RMS',robust_sigma(comppattern_min),'Flat/Comp RMS',robust_sigma(comppattern_min/slitpattern[5:num-5])

;window,19,xsize=500,ysize=500,title='Slit Pattern Comparison',/free
;!P.MULTI=[0,1,3]
;plot,comppattern,/ynozero,title='Slitpattern in Comparison',yrange=[0.9,1.1]
;plot,slitpattern,/ynozero,title='Slitpattern in Flats after relative shift anc scaling',yrange=[0.9,1.1]
;plot,slitpattern/comppattern,/ynozero,title='Ratio',yrange=[0.9,1.1]
;!P.MULTI=0

end
