PRO APALL

	delay=0.0
	samplefac=2; 2 for DAO

;;;
;;; main program
;;;

	filename=DIALOG_PICKFILE(PATH='~/IDL/FOCAS',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop

;
; read main image array
;
	image= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

	image=image+32768 ; offset for DAO data

;
; read ascii extension
;
	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(image2),/device

	result=dialog_menu(['X direction','Y direction'],TITLE='Scan Direction?')
	CASE result OF
		'X direction': BEGIN
			END
		'Y direction': BEGIN
			image=rotate(image,1); rotate 90 deg clockwise
			image2=rotate(image2,1)
			temp=naxis[0]
			naxis[0]=naxis[1]
			naxis[1]=temp
			END
	ENDCASE

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(image2),/device

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	startx=FIX(line)

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	endx=FIX(line)

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=image(FIX(startx),i)
	ENDFOR

	ERASE
	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero


	print,'Find sky region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	skystarty=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	skyendy=FIX(XY[0])
	skywidth=abs(skystarty-skyendy)

	print,'Find object region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	PRINT,Xnew,X2new
	objwidth=abs(X2new-Xnew)
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]
	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]
	
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	skyoffset=FIX(abs(skyendy-coef[1]))
;	print,'skyoffset=',skyoffset

;;;
;;; peak tracing
;;;

	num=endx-startx+1

	ypos=FLTARR(num)
	xpos=FLTARR(num)
	flux=FLTARR(num)
	compflux=FLTARR(num)

i=0
FOR column=startx,endx DO BEGIN
	FOR k=0,naxis[1]-1 do begin
		X[k]=k
		Y[k]=image(column,k)
	ENDFOR

	Xnew=FIX(coef[1]-objwidth/2)
	X2new=FIX(coef[1]+objwidth/2)

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=NORMARRAY(YY)

	est=[1,coef[1],coef[2],0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)

	xpos[i]=column
	ypos[i]=coef[1]

	skyflux=0
	for j=FIX(ypos[i]-skyoffset-skywidth/2),FIX(ypos[i]-skyoffset+skywidth/2) do begin
	skyflux=skyflux+Y[j]
	endfor

	skyflux=skyflux/skywidth

	for j=FIX(ypos[i]-objwidth/2),FIX(ypos[i]+objwidth/2) do begin
	flux[i]=flux[i]+Y[j]-skyflux
	endfor

	i=i+1
ENDFOR ; column loop

result=DIALOG_PLOT2(XDATA=xpos,YDATA=flux,/YNOZERO,$
;	EXECUTE=[$
;	'PLOT, XDATA,YDATA,/YNOZERO',$
;	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='X-Pos.',YTITLE='Flux',Title='Object Flux',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

	filename=DIALOG_PICKFILE(PATH='~/IDL/FOCAS',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop

	comp= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

	comp=comp+32768 ; offset for DAO data

i=0
FOR column=startx,endx DO BEGIN
	FOR k=0,naxis[1]-1 do begin
		X[k]=k
		Y[k]=comp(column,k)
	ENDFOR

	for j=FIX(ypos[i]-objwidth/2),FIX(ypos[i]+objwidth/2) do begin
	compflux[i]=compflux[i]+Y[j];-skyflux
	endfor

	i=i+1
ENDFOR ; column loop

result=DIALOG_PLOT2(XDATA=xpos,YDATA=compflux,/YNOZERO,$
	XTITLE='X-Pos.',YTITLE='Flux',Title='Continuum Trace',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

;
; identify
;
	compwidth=50
	ncomplines=10
	fit_order=2

	compwave=FLTARR(ncomplines)
	lpos=FLTARR(2)
	wave=FLTARR(2)

	linelist2=['5852.4878','7245.167']
	
	compwave[0]=4358.35
	compwave[1]=5460.74
	compwave[2]=5852.4878
	compwave[3]=7032.4127
	compwave[4]=7173.939
	compwave[5]=7245.167
	compwave[6]=7438.899
	compwave[7]=7488.872
	compwave[8]=7535.775
	compwave[9]=8377.607
	ERASE
	WINDOW,0,TITLE='Select a Line (CLICK 2 times)'
	PLOT,xpos,compflux,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])-xpos[0]
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])-xpos[0]
	XX=xpos(XNew:X2new) & YY=compflux(Xnew:X2new)
	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]

	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[0]=DIALOG_LIST(linelist2, TITLE = 'Select Wavelength')
	lpos[0]=EST[1]

	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 1 time)'
	PLOT,xpos,compflux,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])-xpos[0]
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])-xpos[0]

	XX=xpos(XNew:X2new) & YY=compflux(Xnew:X2new)

	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[1] = DIALOG_LIST (linelist2, TITLE = 'Select Wavelength')
	lpos[1]=EST[1]

	fit2_result=POLY_FIT(lpos,wave,1)
;	PRINT,'Fit Reults', fit2_result


;;;
;;; auto-identify
;;;

	fit_result=FLTARR(fit_order)
	lpos2=FLTARR(ncomplines)
	wave2=FLTARR(ncomplines)

new_fit_result=fit2_result

FOR i=0,ncomplines-1 DO BEGIN
	cen=compwave[i]
	lposnew=(cen-compwidth-new_fit_result[0])/new_fit_result[1]
	Xnew=FIX(lposnew)-xpos[0]
	lposnew=(cen+compwidth-new_fit_result[0])/new_fit_result[1]
	X2new=FIX(lposnew)-xpos[0]

	XX=xpos(XNew:X2new) & YY=compflux(Xnew:X2new)
	YY=NORMARRAY(YY)

	plot,XX,YY,/YNOZERO

	lposnew=(cen-new_fit_result[0])/new_fit_result[1]
	est=[1,lposnew,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef
	oplot,XX,result

	wave2[i]=cen
	lpos2[i]=coef[1]

ENDFOR ; end of i loop

;
; wavecalib at one column
;
fit_result=POLY_FIT(lpos2,wave2,1,wavefit)
print,fit_result

plot,lpos2,wave2,/YNOZERO
oplot,lpos2,wave2,psym=2
oplot,lpos2,wavefit

fit_result=POLY_FIT(wave2,lpos2,3,wavefit)
print,fit_result_inverse

FINISH:

END
